/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.calc2;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class Local {
    private static Local loc = null;
    private static DataInputStream dis = null;
    public static final short QHJ_CALC2_ADVANCED_CALCULATOR = 0;
    public static final short QHJ_CALC2_LOAN_CALCULATOR = 1;
    public static final short QHJ_CALC2_STANDARD_CALCULATOR = 2;
    public static final short QTJ_CALC2_ALERT_BEYOND_DOMAIN = 3;
    public static final short QTJ_CALC2_ALERT_DIVISION_BY_ZERO = 4;
    public static final short QTJ_CALC2_ALERT_FOUND_UNEXPECTED_SYMBOL = 5;
    public static final short QTJ_CALC2_ALERT_INFO_POSITIVE = 6;
    public static final short QTJ_CALC2_ALERT_INPUT_LIMIT_REACHED = 7;
    public static final short QTJ_CALC2_ALERT_NEGATIVE_VALUES_NOT_ALLOWED = 8;
    public static final short QTJ_CALC2_ALERT_NOT_ENOUGH_PARAMETERS_FOR_FUNCTION = 9;
    public static final short QTJ_CALC2_ALERT_OPEN_PARENTHESES = 10;
    public static final short QTJ_CALC2_ALERT_OUT_OF_RANGE = 11;
    public static final short QTJ_CALC2_ALERT_TERM_CONTAINS_ERRORS = 12;
    public static final short QTJ_CALC2_ALERT_UNEXPECTED_END_OF_TERM = 13;
    public static final short QTJ_CALC2_ALERT_ZERO_NOT_ALLOWED = 14;
    public static final short QTJ_CALC2_COMMAND_ADVANCED_CALCULATOR = 15;
    public static final short QTJ_CALC2_COMMAND_CALCULATE = 16;
    public static final short QTJ_CALC2_COMMAND_CLEAR = 17;
    public static final short QTJ_CALC2_COMMAND_DISPLAY_IN_DEGREES = 18;
    public static final short QTJ_CALC2_COMMAND_DISPLAY_IN_RADIANS = 19;
    public static final short QTJ_CALC2_COMMAND_INSTRUCTIONS = 20;
    public static final short QTJ_CALC2_COMMAND_LOAN_CALCULATOR = 21;
    public static final short QTJ_CALC2_COMMAND_STANDARD_CALCULATOR = 22;
    public static final short QTJ_CALC2_LABEL_INTEREST_RATE = 23;
    public static final short QTJ_CALC2_LABEL_LOAN_AMOUNT = 24;
    public static final short QTJ_CALC2_LABEL_LOAN_TIME = 25;
    public static final short QTJ_CALC2_LABEL_MONTHLY_FEE = 26;
    public static final short QTJ_CALC2_MISC_DECIMAL_SEPARATOR = 27;
    public static final short QTJ_CALC2_TITLE_CALCULATOR = 28;
    public static final short QTJ_CALC2_TITLE_INSTRUCTIONS = 29;
    public static final short QTJ_CALC2_TITLE_LOAN_CALCULATOR = 30;
    public static final short QTJ_GAME_BACK = 31;
    public static final short QTJ_GAME_EXIT = 32;
    public static final short QTJ_GAME_OK = 33;
    public static final short QTJ_GAME_SELECT = 34;
    public static String phoneLang = System.getProperty("microedition.locale");

    private Local() {
    }

    public static String replace(String source, String replace, String by) {
        int place;
        do {
            if ((place = source.indexOf(replace)) < 0) continue;
            source = source.substring(0, place) + by + source.substring(place + replace.length());
        } while (place >= 0);
        return source;
    }

    public static synchronized String getText(int ltid) {
        return Local.getText(ltid, null);
    }

    public static synchronized String getText(int ltid, String[] p) {
        try {
            if (loc == null) {
                loc = new Local();
            }
            if (dis == null) {
                InputStream is = loc.getClass().getResourceAsStream("/lang." + phoneLang);
                if (is == null) {
                    is = loc.getClass().getResourceAsStream("/lang.xx");
                }
                if (is == null) {
                    return "X";
                }
                dis = new DataInputStream(is);
                dis.mark(512);
            }
            dis.skipBytes(ltid * 2);
            int offset = dis.readUnsignedShort();
            dis.skipBytes(offset - ltid * 2 - 2);
            String str = dis.readUTF();
            if (!dis.markSupported()) {
                dis.close();
                dis = null;
            } else {
                try {
                    dis.reset();
                }
                catch (IOException ex) {
                    dis.close();
                    dis = null;
                }
            }
            if (p != null) {
                if (p.length == 1) {
                    str = Local.replace(str, "%U", p[0]);
                } else {
                    for (int i = 0; i < p.length; ++i) {
                        str = Local.replace(str, "%" + i + "U", p[i]);
                    }
                }
            }
            return str;
        }
        catch (IOException ex) {
            dis = null;
            return "E";
        }
    }

    private static boolean wildcardStringCompare(String a, String b) {
        return Local.wildcardStringCompare(a, b, 0, 0);
    }

    private static boolean wildcardStringCompare(String a, String b, int offseta, int offsetb) {
        block4: while (true) {
            if (offseta == a.length() && offsetb == b.length()) {
                return true;
            }
            if (offseta == a.length() || offsetb == b.length()) {
                return false;
            }
            switch (b.charAt(offsetb)) {
                case '?': {
                    ++offseta;
                    ++offsetb;
                    continue block4;
                }
                case '*': {
                    if (offsetb == b.length() - 1) {
                        return true;
                    }
                    if (Local.wildcardStringCompare(a, b, offseta, offsetb + 1)) {
                        return true;
                    }
                    ++offseta;
                    continue block4;
                }
            }
            if (a.charAt(offseta) != b.charAt(offsetb)) break;
            ++offseta;
            ++offsetb;
        }
        return false;
    }

    private static void deviceCheck() {
        InputStream is;
        String platform = System.getProperty("microedition.platform");
        boolean allowed = false;
        StringBuffer line = new StringBuffer();
        if (loc == null) {
            loc = new Local();
        }
        if ((is = loc.getClass().getResourceAsStream("/META-INF/MANIFEST.MF")) != null) {
            block2: while (true) {
                try {
                    while (true) {
                        int c;
                        if ((c = is.read()) < 0) {
                            return;
                        }
                        if ((char)c == '\r') continue;
                        if ((char)c == '\n') {
                            if (line.toString().trim().startsWith("Nokia-Platform:")) {
                                line.append((Object)Local.multipleLine(is));
                                break block2;
                            }
                            line.delete(0, line.length());
                            continue;
                        }
                        line.append((char)c);
                    }
                }
                catch (IOException e) {
                    continue;
                }
                break;
            }
            String str = line.toString().trim().substring(15);
            Vector<String> v = new Vector<String>();
            int komma_index = 0;
            while ((komma_index = str.indexOf("@")) != -1) {
                v.addElement(str.substring(0, komma_index));
                str = str.substring(komma_index + 1, str.length());
            }
            v.addElement(str);
            for (int i = 0; i < v.size(); ++i) {
                if (!Local.wildcardStringCompare(platform, ((String)v.elementAt(i)).trim())) continue;
                allowed = true;
                break;
            }
        }
        if (!allowed) {
            System.exit(0);
        }
    }

    private static StringBuffer multipleLine(InputStream is) {
        StringBuffer line = new StringBuffer();
        try {
            int c = is.read();
            if ((char)c != ' ') {
                return line;
            }
            while ((c = is.read()) >= 0) {
                if ((char)c == '\r') continue;
                if ((char)c == '\n') {
                    line.append((Object)Local.multipleLine(is));
                    break;
                }
                line.append((char)c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return line;
    }

    public static synchronized void localeChanged() {
        Local.releaseResources();
        phoneLang = System.getProperty("microedition.locale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void releaseResources() {
        if (dis != null) {
            try {
                dis.close();
            }
            catch (IOException iOException) {
            }
            finally {
                dis = null;
            }
        }
    }

    static {
        Local.deviceCheck();
    }
}

